<?php
$title='Mensajes';
require_once __DIR__ . '/../inc/header.php';
if(!is_client_user()){ redirect('messages/list.php'); }

$pdo=db();
$user=current_user();
$client_id=(int)($user['client_id'] ?? 0);

$msgs=$pdo->prepare("SELECT * FROM messages WHERE client_id=? ORDER BY created_at DESC LIMIT 200");
$msgs->execute([$client_id]);
$rows=$msgs->fetchAll();
$pdo->prepare("UPDATE messages SET is_read=1 WHERE client_id=? AND is_read=0")->execute([$client_id]);
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Mensajes</h4>
</div>
<div class="card shadow-sm"><div class="card-body">
  <?php if(!$rows): ?>
    <div class="text-muted">No tienes mensajes.</div>
  <?php else: ?>
    <div class="list-group list-group-flush">
      <?php foreach($rows as $m): ?>
        <div class="list-group-item">
          <div class="small text-muted"><?= h($m['created_at']) ?></div>
          <div class="fw-semibold"><?= h($m['subject']) ?></div>
          <div><?= nl2br(h($m['body'])) ?></div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div></div>
<?php require_once __DIR__ . '/../inc/footer.php'; ?>
