<?php
declare(strict_types=1);

function csrf_token(): string {
  if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(32));
  }
  return $_SESSION['csrf'];
}

function csrf_verify(?string $token): void {
  $sess = $_SESSION['csrf'] ?? '';
  if (!$token || !$sess || !hash_equals($sess, $token)) {
    http_response_code(400);
    echo "CSRF inválido";
    exit;
  }
}

function e(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function now_iso(): string {
  return (new DateTimeImmutable('now'))->format(DateTimeInterface::ATOM);
}
function human_bytes(int $bytes): string {
  $units = ['B','KB','MB','GB','TB'];
  $i = 0;
  $b = (float)$bytes;
  while ($b >= 1024 && $i < count($units)-1) {
    $b /= 1024;
    $i++;
  }
  if ($i === 0) return (string)intval($b) . ' ' . $units[$i];
  return rtrim(rtrim(number_format($b, 1, '.', ''), '0'), '.') . ' ' . $units[$i];
}

function require_post(): void {
  if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo "Método no permitido";
    exit;
  }
}

/* ---- Avatar + CSRF helpers (patch) ---- */
if (!function_exists('csrf_token')) {
  function csrf_token(): string {
    if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }
    if (empty($_SESSION['csrf_token']) || !is_string($_SESSION['csrf_token'])) {
      $_SESSION['csrf_token'] = bin2hex(random_bytes(16));
    }
    return $_SESSION['csrf_token'];
  }
}
if (!function_exists('csrf_check')) {
  function csrf_check(): void {
    if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }
    $token = $_POST['csrf'] ?? ($_GET['csrf'] ?? '');
    $expected = $_SESSION['csrf_token'] ?? '';
    if (!is_string($token) || $token === '' || !is_string($expected) || $expected === '' || !hash_equals($expected, $token)) {
      http_response_code(400);
      echo 'CSRF inválido';
      exit;
    }
  }
}
if (!function_exists('avatar_url')) {
  function avatar_url(array $user): string {
    $id = (int)($user['id'] ?? 0);
    return 'index.php?route=avatar&id=' . $id;
  }
}
if (!function_exists('avatar_disk_path')) {
  function avatar_disk_path(array $config, int $userId): string {
    $base = $config['storage_dir'] ?? '';
    if (!is_string($base) || $base === '') {
      $base = dirname(__DIR__, 2) . '/storage';
    }
    $base = rtrim($base, '/');
    $dir = $base . '/avatars';
    if (!is_dir($dir)) { @mkdir($dir, 0775, true); }
    return $dir . '/' . $userId . '.bin';
  }
}
