<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= e($title ?? 'IMAStorage') ?></title>
  <link rel="stylesheet" href="assets/app.css" />
</head>
<body>
  <?php $me = $user ?? null; ?>
  <header class="topbar">
    <div class="topbar-left">
      <a class="brand" href="index.php?route=files">IMAStorage</a>
      <?php if (!empty($me)): ?>
        <nav class="nav-links">
          <a href="index.php?route=files">Mis archivos</a>
          <a href="index.php?route=profile">Perfil</a>
          <?php if (($me['role'] ?? 'user') === 'admin'): ?>
            <a href="index.php?route=admin_users">Admin</a>
          <?php endif; ?>
        </nav>
      <?php endif; ?>
    </div>

    <div class="topbar-right">
      <?php if (!empty($me)): ?>
        <a class="user-chip" href="index.php?route=profile" title="Perfil">
          <img class="avatar" src="<?= e(avatar_url($me)) ?>" alt="Avatar">
          <span class="user-name"><?= e($me['username']) ?></span>
        </a>
        <a class="btn" href="index.php?route=logout">Salir</a>
      <?php else: ?>
        <a class="btn" href="index.php?route=login">Entrar</a>
        <a class="btn primary" href="index.php?route=register">Registro</a>
      <?php endif; ?>
    </div>
  </header>

  <main class="container">
    <?= $content ?>
  </main>
</body>
</html>
