<?php $me = $user ?? null; ?>
<?php if (!$me) { echo '<div class="card"><p>Debes iniciar sesión.</p></div>'; return; } ?>

<?php if (isset($_SESSION['flash_ok'])): ?>
  <div class="alert ok"><?= e($_SESSION['flash_ok']); unset($_SESSION['flash_ok']); ?></div>
<?php endif; ?>
<?php if (isset($_SESSION['flash_err'])): ?>
  <div class="alert err"><?= e($_SESSION['flash_err']); unset($_SESSION['flash_err']); ?></div>
<?php endif; ?>

<?php
$csrf = function_exists('csrf_token') ? csrf_token() : ($_SESSION['csrf_token'] ?? '');
?>

<div class="card">
  <h2 style="margin:0 0 12px 0;">Perfil</h2>

  <div class="row" style="gap:14px; align-items:center; flex-wrap:wrap;">
    <img id="avatarPreview" class="avatar-lg" src="<?= e(avatar_url($me)) ?>" alt="Avatar">
    <div>
      <div style="font-weight:700; font-size:16px;"><?= e($me['username']) ?></div>
      <div class="small muted">Avatar en JPG/PNG/WebP/GIF. Máximo 5MB.</div>
    </div>
  </div>

  <form id="avatarForm" style="margin-top:12px;" class="row" method="post" action="index.php?route=profile_avatar" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="<?= e($csrf) ?>">
    <input id="avatarInput" class="file-hidden" type="file" name="avatar" accept="image/*" required>
    <button id="pickAvatar" class="btn primary" type="button">Cambiar avatar</button>
    <button id="uploadAvatar" class="btn" type="submit" disabled>Subir</button>
    <span id="avatarHint" class="small muted" style="margin-left:6px;"></span>
  </form>

  <hr style="border:none; border-top:1px solid #e2e8f0; margin:16px 0;">

  <h3 style="margin:0 0 10px 0;">Cambiar usuario / contraseña</h3>
  <form class="row" method="post" action="index.php?route=profile_update" style="gap:10px; flex-wrap:wrap;">
    <input type="hidden" name="csrf" value="<?= e($csrf) ?>">
    <input name="username" value="<?= e($me['username']) ?>" placeholder="Usuario" required>
    <input name="password" type="password" placeholder="Nueva contraseña (opcional)">
    <button class="btn" type="submit">Guardar</button>
  </form>
  <div class="small muted" style="margin-top:8px;">Si dejas la contraseña vacía, no se cambia.</div>
</div>

<script>
(function(){
  const input = document.getElementById('avatarInput');
  const pick = document.getElementById('pickAvatar');
  const upload = document.getElementById('uploadAvatar');
  const preview = document.getElementById('avatarPreview');
  const hint = document.getElementById('avatarHint');
  if (!input || !pick || !upload || !preview) return;
  pick.addEventListener('click', () => input.click());
  input.addEventListener('change', () => {
    const f = (input.files && input.files[0]) ? input.files[0] : null;
    if (!f) { upload.disabled = true; hint.textContent=''; return; }
    const max = 5 * 1024 * 1024;
    if (f.size > max) { upload.disabled = true; hint.textContent='Demasiado grande (máx 5MB).'; return; }
    upload.disabled = false; hint.textContent = f.name;
    try { const url = URL.createObjectURL(f); preview.src = url; preview.onload = () => URL.revokeObjectURL(url); } catch(e){}
  });
})();
</script>
