<?php
declare(strict_types=1);

$config = require __DIR__ . '/config.php';

date_default_timezone_set('Europe/Madrid');

if (!is_dir($config['base_path'].'/data')) @mkdir($config['base_path'].'/data', 0775, true);
if (!is_dir($config['storage_path'])) @mkdir($config['storage_path'], 0775, true);
if (!is_dir($config['tmp_path'])) @mkdir($config['tmp_path'], 0775, true);

session_name($config['session_name']);
session_start();

require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/security.php';
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/files.php';
require_once __DIR__ . '/lib/messages.php';
require_once __DIR__ . '/lib/admin.php';

$db = db_connect($config['db_path']);
db_migrate($db);

$GLOBALS['IMASTORAGE'] = [
  'config' => $config,
  'db' => $db,
];
