<?php declare(strict_types=1); ?>
<div class="grid">
  <div class="card">
    <h2>Enviar mensaje</h2>
    <form method="post" action="index.php?route=message_send">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <label>Para (usuario o email)</label>
      <input name="to" placeholder="ej: ana" required>
      <label>Mensaje</label>
      <textarea name="body" rows="5" required></textarea>
      <div class="row" style="margin-top:12px;">
        <button class="btn primary" type="submit">Enviar</button>
      </div>
    </form>

    <?php if (($user['role'] ?? 'user') === 'admin'): ?>
      <hr style="border:none;border-top:1px solid #e7ebf3;margin:16px 0;">
      <h2>Mensaje global (Admin → todos)</h2>
      <form method="post" action="index.php?route=broadcast_send">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <label>Título</label>
        <input name="title" required>
        <label>Mensaje</label>
        <textarea name="body" rows="4" required></textarea>
        <div class="row" style="margin-top:12px;">
          <button class="btn primary" type="submit">Enviar a todos</button>
          <a class="btn" href="index.php?route=admin_broadcasts">Gestionar</a>
        </div>
      </form>
      <p class="small">Al usuario le saldrá como popup la próxima vez que entre. Puedes anularlo desde <a href="index.php?route=admin_broadcasts">Admin · Mensajes globales</a>.</p>
    <?php endif; ?>
  </div>

  <div class="card">
    <h2>Bandeja de entrada</h2>
    <table class="table">
      <thead><tr><th>De</th><th>Mensaje</th><th>Fecha</th><th></th></tr></thead>
      <tbody>
        <?php if (empty($inbox)): ?>
          <tr><td colspan="4" class="small">Sin mensajes.</td></tr>
        <?php endif; ?>
        <?php foreach ($inbox as $m): ?>
          <tr>
            <td><?= e($m['sender_username']) ?><?= $m['is_read'] ? '' : ' <span class="badge">nuevo</span>' ?></td>
            <td><?= nl2br(e($m['body'])) ?></td>
            <td class="small"><?= e($m['created_at']) ?></td>
            <td>
              <form method="post" action="index.php?route=message_delete" onsubmit="return confirm('¿Borrar mensaje?');">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$m['id'] ?>">
                <button class="btn danger" type="submit">Borrar</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <h2 style="margin-top:14px;">Enviados</h2>
    <table class="table">
      <thead><tr><th>Para</th><th>Mensaje</th><th>Fecha</th><th></th></tr></thead>
      <tbody>
        <?php if (empty($sent)): ?>
          <tr><td colspan="4" class="small">Sin enviados.</td></tr>
        <?php endif; ?>
        <?php foreach ($sent as $m): ?>
          <tr>
            <td><?= e($m['receiver_username']) ?></td>
            <td><?= nl2br(e($m['body'])) ?></td>
            <td class="small"><?= e($m['created_at']) ?></td>
            <td>
              <form method="post" action="index.php?route=message_delete" onsubmit="return confirm('¿Borrar mensaje?');">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$m['id'] ?>">
                <button class="btn danger" type="submit">Borrar</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
