<?php declare(strict_types=1); ?>
<div class="card">
  <div class="row" style="align-items:center;">
    <h2 style="margin:0;">Carpeta compartida</h2>
    <div class="right small">Dueño: <?= e($owner['username']) ?> · Permiso: <span class="badge"><?= e($perm) ?></span></div>
  </div>

  <div class="path" style="margin-top:10px;">
    <?php foreach ($crumbs as $c): ?>
      <a href="index.php?route=shared_folder&sid=<?= (int)$sid ?>&folder=<?= (int)$c['id'] ?>">
        <?= e($c['name'] === '/' ? 'Raíz' : $c['name']) ?>
      </a>
      <span class="small">/</span>
    <?php endforeach; ?>
  </div>

  <h3 style="margin-top:16px;">Carpetas</h3>
  <table class="table">
    <thead><tr><th>Nombre</th><th>Creada</th></tr></thead>
    <tbody>
      <?php if (empty($listing['folders'])): ?>
        <tr><td colspan="2" class="small">Sin carpetas</td></tr>
      <?php endif; ?>
      <?php foreach ($listing['folders'] as $f): ?>
        <tr>
          <td>📁 <a href="index.php?route=shared_folder&sid=<?= (int)$sid ?>&folder=<?= (int)$f['id'] ?>"><?= e($f['name']) ?></a></td>
          <td class="small"><?= e($f['created_at']) ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <h3 style="margin-top:16px;">Archivos</h3>
  <table class="table">
    <thead><tr><th>Nombre</th><th>Tamaño</th><th>Tipo</th><th>Acciones</th></tr></thead>
    <tbody>
      <?php if (empty($listing['files'])): ?>
        <tr><td colspan="4" class="small">Sin archivos</td></tr>
      <?php endif; ?>
      <?php foreach ($listing['files'] as $fi): ?>
        <tr>
          <td>📄 <?= e($fi['orig_name']) ?></td>
          <td class="small"><?= number_format(((int)$fi['size_bytes'])/1024, 1) ?> KB</td>
          <td class="small mono"><?= e($fi['mime']) ?></td>
          <td class="row">
            <a class="btn" href="index.php?route=file_preview&id=<?= (int)$fi['id'] ?>">Ver</a>
            <a class="btn" href="index.php?route=file_download&id=<?= (int)$fi['id'] ?>">Descargar</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <p class="small" style="margin-top:10px;">En esta vista solo se muestran acciones de lectura. Para editar, el dueño debe compartir con permiso write y se habilitará en una fase posterior.</p>
</div>
