<?php declare(strict_types=1); ?>
<div class="card">
  <div class="row" style="align-items:center;">
    <h2 style="margin:0;">Mis archivos</h2>
    <div class="right small">Permisos: lectura <?= $user['can_read'] ? '✅' : '❌' ?> · escritura <?= $user['can_write'] ? '✅' : '❌' ?></div>
  </div>

  <div class="path" style="margin-top:10px;">
    <?php foreach ($crumbs as $c): ?>
      <a href="index.php?route=files&folder=<?= (int)$c['id'] ?>"><?= e($c['name'] === '/' ? 'Raíz' : $c['name']) ?></a>
      <span class="small">/</span>
    <?php endforeach; ?>
  </div>

  <div class="row" style="margin-top:12px;">
    <?php if ($user['can_write']): ?>
      <form method="post" action="index.php?route=folder_create" class="row" style="gap:10px;">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="parent_id" value="<?= (int)$folder['id'] ?>">
        <input name="name" placeholder="Nueva carpeta" style="width: 220px;">
        <button class="btn" type="submit">Crear carpeta</button>
      </form>

      <form method="post" action="index.php?route=file_upload" enctype="multipart/form-data" class="row" style="gap:10px;">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="folder_id" value="<?= (int)$folder['id'] ?>">
        <input type="file" name="file" required style="width: 280px;">
        <button class="btn primary" type="submit">Subir</button>
      </form>
    <?php endif; ?>
  </div>

  <h3 style="margin-top:16px;">Carpetas</h3>
  <table class="table">
    <thead><tr><th>Nombre</th><th>Creada</th><th>Acciones</th></tr></thead>
    <tbody>
      <?php if (empty($listing['folders'])): ?>
        <tr><td colspan="3" class="small">Sin carpetas</td></tr>
      <?php endif; ?>
      <?php foreach ($listing['folders'] as $f): ?>
        <tr>
          <td>📁 <a href="index.php?route=files&folder=<?= (int)$f['id'] ?>"><?= e($f['name']) ?></a></td>
          <td class="small"><?= e($f['created_at']) ?></td>
          <td class="row">
            <?php if ($user['can_write']): ?>
              <form method="post" action="index.php?route=folder_rename" class="row">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$f['id'] ?>">
                <input name="name" placeholder="Renombrar" style="width:140px;">
                <button class="btn" type="submit">OK</button>
              </form>
              <form method="post" action="index.php?route=folder_move" class="row">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$f['id'] ?>">
                <input name="dest" placeholder="ID carpeta destino" style="width:160px;">
                <button class="btn" type="submit">Mover</button>
              </form>
              <form method="post" action="index.php?route=folder_delete" onsubmit="return confirm('¿Borrar carpeta y contenido?');">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$f['id'] ?>">
                <button class="btn danger" type="submit">Borrar</button>
              </form>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <h3 style="margin-top:16px;">Archivos</h3>
  <table class="table">
    <thead><tr><th>Nombre</th><th>Tamaño</th><th>Tipo</th><th>Acciones</th></tr></thead>
    <tbody>
      <?php if (empty($listing['files'])): ?>
        <tr><td colspan="4" class="small">Sin archivos</td></tr>
      <?php endif; ?>
      <?php foreach ($listing['files'] as $fi): ?>
        <tr>
          <td>📄 <?= e($fi['orig_name']) ?></td>
          <td class="small"><?= number_format(((int)$fi['size_bytes'])/1024, 1) ?> KB</td>
          <td class="small mono"><?= e($fi['mime']) ?></td>
          <td class="row">
            <a class="btn" href="index.php?route=file_preview&id=<?= (int)$fi['id'] ?>">Ver</a>
            <a class="btn" href="index.php?route=file_download&id=<?= (int)$fi['id'] ?>">Descargar</a>
            <?php if ($user['can_write']): ?>
              <form method="post" action="index.php?route=file_rename" class="row">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$fi['id'] ?>">
                <input name="name" placeholder="Renombrar" style="width:160px;">
                <button class="btn" type="submit">OK</button>
              </form>
              <form method="post" action="index.php?route=file_move" class="row">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$fi['id'] ?>">
                <input name="dest" placeholder="ID carpeta destino" style="width:160px;">
                <button class="btn" type="submit">Mover</button>
              </form>
              <form method="post" action="index.php?route=file_delete" onsubmit="return confirm('¿Borrar archivo?');">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$fi['id'] ?>">
                <button class="btn danger" type="submit">Borrar</button>
              </form>
            <?php endif; ?>
            <a class="btn" href="index.php?route=file_share&id=<?= (int)$fi['id'] ?>">Compartir</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <p class="small" style="margin-top:12px;">
    💡 Para mover carpetas/archivos, usa el ID de la carpeta destino (lo ves en la URL al entrar en una carpeta).
    En una iteración siguiente podemos añadir selector visual tipo árbol.
  </p>
</div>
