<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= e($title ?? 'IMAStorage') ?></title>
  <link rel="stylesheet" href="assets/app.css" />
</head>
<body>
  <div class="nav">
    <div class="brand"><a href="index.php">IMAStorage</a></div>
    <div class="spacer"></div>
    <?php if (!empty($user)): ?>
      <span class="badge"><?= e($user['username']) ?> · <?= e($user['role']) ?></span>
      <a class="btn" href="index.php?route=files">Mis archivos</a>
      <a class="btn" href="index.php?route=shared">Compartidos</a>
      <a class="btn" href="index.php?route=messages">Mensajes</a>
      <a class="btn" href="index.php?route=profile">Perfil</a>
      <?php if (($user['role'] ?? 'user') === 'admin'): ?>
        <a class="btn" href="index.php?route=admin_users">Admin</a>
        <a class="btn" href="index.php?route=admin_broadcasts">Broadcasts</a>
      <?php endif; ?>
      <a class="btn" href="index.php?route=logout">Salir</a>
    <?php else: ?>
      <a class="btn" href="index.php?route=login">Entrar</a>
      <a class="btn primary" href="index.php?route=register">Registro</a>
    <?php endif; ?>
  </div>

  <div class="container">
    <?php if (!empty($_SESSION['flash_ok'])): ?>
      <div class="flash ok"><?= e($_SESSION['flash_ok']); unset($_SESSION['flash_ok']); ?></div>
    <?php endif; ?>
    <?php if (!empty($_SESSION['flash_err'])): ?>
      <div class="flash err"><?= e($_SESSION['flash_err']); unset($_SESSION['flash_err']); ?></div>
    <?php endif; ?>

    <?= $content ?? '' ?>
  </div>

  <div id="modalBackdrop" class="modal-backdrop">
    <div class="modal" role="dialog" aria-modal="true">
      <div class="row">
        <h3 id="modalTitle" style="margin:0;"></h3>
        <button class="btn right" data-modal-close="1">X</button>
      </div>
      <div id="modalBody" class="preview"></div>
      <div class="actions">
        <button id="modalOk" class="btn primary" data-modal-close="1">Cerrar</button>
      </div>
    </div>
  </div>

  <script>
    window.CSRF_TOKEN = <?= json_encode(csrf_token()) ?>;
  </script>
  <script src="assets/app.js"></script>

  <?php if (!empty($broadcast)): ?>
    <script>
      showModal(
        <?= json_encode($broadcast['title']) ?>,
        "<p class='small'>Mensaje del administrador · <?= e($broadcast['created_at']) ?></p>" +
        "<div><?= nl2br(e($broadcast['body'])) ?></div>",
        "Entendido"
      );
      markBroadcastRead(<?= (int)$broadcast['id'] ?>);
    </script>
  <?php endif; ?>
</body>
</html>
