function showModal(title, html, okText="Cerrar") {
  const backdrop = document.getElementById("modalBackdrop");
  const mt = document.getElementById("modalTitle");
  const mb = document.getElementById("modalBody");
  const ok = document.getElementById("modalOk");
  mt.textContent = title;
  mb.innerHTML = html;
  ok.textContent = okText;
  backdrop.style.display = "flex";
}
function hideModal() {
  const backdrop = document.getElementById("modalBackdrop");
  backdrop.style.display = "none";
}
document.addEventListener("click", (e) => {
  if (e.target && e.target.matches("[data-modal-close]")) hideModal();
  if (e.target && e.target.id === "modalBackdrop") hideModal();
});

async function markBroadcastRead(id) {
  try {
    await fetch("index.php?route=broadcast_read", {
      method: "POST",
      headers: {"Content-Type":"application/x-www-form-urlencoded"},
      body: "id=" + encodeURIComponent(id) + "&csrf=" + encodeURIComponent(window.CSRF_TOKEN || "")
    });
  } catch(e){}
}
