<?php
require_once __DIR__ . '/helpers.php';
require_login();
$title = $title ?? 'CRM';
$flash = flash_get();
$user = current_user();
$unread = unread_messages_count();
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= h($title) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    :root{
      --crm-blue-900:#123a66;
      --crm-blue-800:#1a4b82;
      --crm-blue-700:#2a6bb3;
      --crm-card:#ffffff;
      --crm-text:#0b1220;
    }
    body{background: radial-gradient(1200px 800px at 20% 0%, var(--crm-blue-700), var(--crm-blue-900)); color: #eaf2ff;}
    .container-wide{max-width:1200px;}
    .navbar{background: rgba(18,58,102,.78) !important; backdrop-filter: blur(8px); border-bottom: 1px solid rgba(255,255,255,.10);}
    .navbar .nav-link, .navbar .navbar-brand{color:#eaf2ff !important;}
    .navbar .nav-link:hover{opacity:.92}
    .card{background: var(--crm-card); color: var(--crm-text); border: 1px solid rgba(255,255,255,.10);}
    .alert{border-radius:14px}
    .nav-avatar{width:32px;height:32px;border-radius:10px;object-fit:cover;border:1px solid rgba(255,255,255,.18);background:#fff;}
    @media (min-width: 992px){
      .navbar .collapse{display:flex !important; height:auto !important; visibility:visible !important;}
      .navbar-toggler{display:none;}
    }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg sticky-top">
  <div class="container container-wide">
    <a class="navbar-brand fw-semibold" href="<?= url('dashboard.php') ?>">Inicio/Tablón</a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#topNav" aria-controls="topNav" aria-expanded="false" aria-label="Menú">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="topNav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <?php if(!is_client_user()): ?>
          <li class="nav-item"><a class="nav-link" href="<?= url('clientes/list.php') ?>">Clientes</a></li>
          <li class="nav-item"><a class="nav-link" href="<?= url('presupuestos/list.php') ?>">Presupuestos</a></li>
          <li class="nav-item"><a class="nav-link" href="<?= url('facturas/list.php') ?>">Facturas</a></li>
          <li class="nav-item">
            <a class="nav-link" href="<?= url('messages/inbox.php') ?>">
              Mensajes
              <?php if($unread>0): ?><span class="badge text-bg-warning ms-1"><?= (int)$unread ?></span><?php endif; ?>
            </a>
          </li>
          <?php if(is_admin()): ?>
            <li class="nav-item"><a class="nav-link" href="<?= url('admin/users.php') ?>">Usuarios</a></li>
            <li class="nav-item"><a class="nav-link" href="<?= url('settings/index.php') ?>">Ajustes</a></li>
          <?php endif; ?>
        <?php else: ?>
          <li class="nav-item"><a class="nav-link" href="<?= url('client/panel.php') ?>">Mi panel</a></li>
          <li class="nav-item">
            <a class="nav-link" href="<?= url('messages/inbox.php') ?>">
              Mensajes
              <?php if($unread>0): ?><span class="badge text-bg-warning ms-1"><?= (int)$unread ?></span><?php endif; ?>
            </a>
          </li>
        <?php endif; ?>
      </ul>

      <div class="d-flex align-items-center gap-2">
        <a class="text-decoration-none text-white-50 small" href="<?= url('users/profile.php') ?>"><?= h($user['username'] ?? '') ?></a>
        <a href="<?= url('users/profile.php') ?>" class="d-inline-flex align-items-center">
          <img class="nav-avatar" alt="avatar" src="<?= h(avatar_url($user ?? [])) ?>">
        </a>
        <a class="btn btn-sm btn-outline-light" href="<?= url('logout.php') ?>">Salir</a>
      </div>
    </div>
  </div>
</nav>

<div class="container container-wide py-3">
  <?php foreach($flash as $f): ?>
    <div class="alert alert-<?= h($f['type']) ?>"><?= h($f['msg']) ?></div>
  <?php endforeach; ?>
