<?php
$title='Nuevo mensaje';
require_once __DIR__ . '/../inc/header.php';
if(is_client_user()){ http_response_code(403); exit('No autorizado'); }

$pdo=db();
ensure_schema_safe();

$dest = (string)($_GET['dest'] ?? 'client'); // client|user
if(!in_array($dest,['client','user'],true)) $dest='client';

if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $dest = (string)($_POST['dest'] ?? 'client');
  $subject = trim((string)($_POST['subject'] ?? ''));
  $body = trim((string)($_POST['body'] ?? ''));
  $parent_id = (int)($_POST['parent_id'] ?? 0);

  if($subject==='' || $body===''){
    flash_set('danger','Asunto y mensaje son obligatorios.');
    redirect('messages/new.php?dest='.$dest);
  }

  if($dest==='client'){
    $client_id = (int)($_POST['client_id'] ?? 0);
    if($client_id<=0){ flash_set('danger','Selecciona un cliente.'); redirect('messages/new.php?dest=client'); }
    $st=$pdo->prepare("INSERT INTO messages(client_id, from_user_id, subject, body, parent_id, is_read, created_at) VALUES(?,?,?,?,?,0,NOW())");
    $st->execute([$client_id, (int)current_user()['id'], $subject, $body, $parent_id?:null]);
    $msg_id=(int)$pdo->lastInsertId();

    // attachment
    if(!empty($_FILES['attachment'])){
      $saved = save_uploaded_file($_FILES['attachment'], 'client_'.$msg_id);
      if($saved){
        $sf=$pdo->prepare("INSERT INTO message_files(msg_type,msg_id,original_name,stored_path) VALUES('client',?,?,?)");
        $sf->execute([$msg_id, $saved['original'], $saved['stored']]);
      }
    }

    // email notify if client has email
    $c=$pdo->prepare("SELECT email, nombre, apellidos FROM clients WHERE id=?");
    $c->execute([$client_id]);
    $ci=$c->fetch();
    $to=trim((string)($ci['email'] ?? ''));
    if($to!==''){
      $txt = "Hola ".trim(($ci['nombre']??'')." ".($ci['apellidos']??'')).",\n\n".
             $body."\n\n".
             "Puedes entrar al portal para ver el mensaje.";
      @send_simple_mail($to, "Nuevo mensaje: ".$subject, $txt);
    }

    flash_set('success','Mensaje enviado al cliente.');
    redirect('messages/new.php?dest=client');
  } else {
    $receiver_id=(int)($_POST['receiver_id'] ?? 0);
    if($receiver_id<=0){ flash_set('danger','Selecciona un usuario.'); redirect('messages/new.php?dest=user'); }
    $st=$pdo->prepare("INSERT INTO user_messages(sender_id, receiver_id, subject, body, parent_id, is_read, created_at) VALUES(?,?,?,?,?,0,NOW())");
    $st->execute([(int)current_user()['id'], $receiver_id, $subject, $body, $parent_id?:null]);
    $msg_id=(int)$pdo->lastInsertId();

    if(!empty($_FILES['attachment'])){
      $saved = save_uploaded_file($_FILES['attachment'], 'user_'.$msg_id);
      if($saved){
        $sf=$pdo->prepare("INSERT INTO message_files(msg_type,msg_id,original_name,stored_path) VALUES('user',?,?,?)");
        $sf->execute([$msg_id, $saved['original'], $saved['stored']]);
      }
    }

    flash_set('success','Mensaje enviado al usuario.');
    redirect('messages/new.php?dest=user');
  }
}

$clients = $pdo->query("SELECT id, nombre, apellidos, email FROM clients ORDER BY nombre ASC LIMIT 2000")->fetchAll();
$users = $pdo->query("SELECT id, username, role FROM users ORDER BY username ASC")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
  <h4 class="mb-0">Nuevo mensaje</h4>
  <div class="btn-group">
    <a class="btn btn-outline-light <?= $dest==='client'?'active':'' ?>" href="<?= url('messages/new.php?dest=client') ?>">A cliente</a>
    <a class="btn btn-outline-light <?= $dest==='user'?'active':'' ?>" href="<?= url('messages/new.php?dest=user') ?>">A usuario</a>
  </div>
</div>

<div class="card shadow-sm">
  <div class="card-body">
    <form method="post" enctype="multipart/form-data" class="row g-3">
      <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
      <input type="hidden" name="dest" value="<?= h($dest) ?>">
      <input type="hidden" name="parent_id" value="0">

      <?php if($dest==='client'): ?>
        <div class="col-12">
          <label class="form-label">Cliente</label>
          <select class="form-select" name="client_id" required>
            <option value="">-- Selecciona cliente --</option>
            <?php foreach($clients as $c): ?>
              <option value="<?= (int)$c['id'] ?>"><?= h(trim($c['nombre'].' '.$c['apellidos'])) ?><?= $c['email']?' · '.h($c['email']):'' ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      <?php else: ?>
        <div class="col-12">
          <label class="form-label">Usuario</label>
          <select class="form-select" name="receiver_id" required>
            <option value="">-- Selecciona usuario --</option>
            <?php foreach($users as $uu): if((int)$uu['id']==(int)current_user()['id']) continue; ?>
              <option value="<?= (int)$uu['id'] ?>"><?= h($uu['username']) ?><?= $uu['role']?' · '.h($uu['role']):'' ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      <?php endif; ?>

      <div class="col-12">
        <label class="form-label">Asunto</label>
        <input class="form-control" name="subject" required>
      </div>
      <div class="col-12">
        <label class="form-label">Mensaje</label>
        <textarea class="form-control" name="body" rows="6" required></textarea>
      </div>
      <div class="col-12">
        <label class="form-label">Adjuntar archivo (opcional)</label>
        <input class="form-control" type="file" name="attachment">
        <div class="form-text">Si tu hosting limita tamaño, lo ajustamos.</div>
      </div>
      <div class="col-12">
        <button class="btn btn-primary">Enviar</button>
        <a class="btn btn-outline-secondary" href="<?= url('messages/inbox.php') ?>">Volver</a>
      </div>
    </form>
  </div>
</div>

<?php require_once __DIR__ . '/../inc/footer.php'; ?>
