<?php
$title='Responder';
require_once __DIR__ . '/../inc/header.php';
if(is_client_user()){ http_response_code(403); exit('No autorizado'); }

$pdo=db();
ensure_schema_safe();

$type = (string)($_GET['type'] ?? 'user'); // user|client
$id = (int)($_GET['id'] ?? 0);

if(!in_array($type,['user','client'],true) || $id<=0){ redirect('messages/inbox.php'); }

if($type==='user'){
  $st=$pdo->prepare("SELECT um.*, u.username AS other_name
                     FROM user_messages um
                     JOIN users u ON u.id=um.sender_id
                     WHERE um.id=?");
  $st->execute([$id]);
  $m=$st->fetch();
  if(!$m){ redirect('messages/inbox.php'); }
  $dest='user';
  $receiver_id=(int)$m['sender_id'];
  $subject='RE: '.$m['subject'];
  $quoted="\n\n---\n".$m['body'];
} else {
  $st=$pdo->prepare("SELECT m.*, c.nombre, c.apellidos
                     FROM messages m JOIN clients c ON c.id=m.client_id
                     WHERE m.id=?");
  $st->execute([$id]);
  $m=$st->fetch();
  if(!$m){ redirect('messages/inbox.php'); }
  $dest='client';
  $client_id=(int)$m['client_id'];
  $subject='RE: '.$m['subject'];
  $quoted="\n\n---\n".$m['body'];
}

?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Responder</h4>
</div>

<div class="card shadow-sm"><div class="card-body">
  <form method="post" action="<?= url('messages/new.php?dest='.$dest) ?>" enctype="multipart/form-data" class="row g-3">
    <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
    <input type="hidden" name="dest" value="<?= h($dest) ?>">
    <input type="hidden" name="parent_id" value="<?= (int)$id ?>">
    <?php if($dest==='user'): ?>
      <input type="hidden" name="receiver_id" value="<?= (int)$receiver_id ?>">
      <div class="col-12"><div class="text-muted">Para: usuario #<?= (int)$receiver_id ?></div></div>
    <?php else: ?>
      <input type="hidden" name="client_id" value="<?= (int)$client_id ?>">
      <div class="col-12"><div class="text-muted">Para: cliente #<?= (int)$client_id ?></div></div>
    <?php endif; ?>

    <div class="col-12">
      <label class="form-label">Asunto</label>
      <input class="form-control" name="subject" value="<?= h($subject) ?>" required>
    </div>
    <div class="col-12">
      <label class="form-label">Mensaje</label>
      <textarea class="form-control" name="body" rows="7" required><?= h($quoted) ?></textarea>
    </div>
    <div class="col-12">
      <label class="form-label">Adjuntar archivo (opcional)</label>
      <input class="form-control" type="file" name="attachment">
    </div>
    <div class="col-12">
      <button class="btn btn-primary">Enviar</button>
      <a class="btn btn-outline-secondary" href="<?= url('messages/inbox.php') ?>">Cancelar</a>
    </div>
  </form>
</div></div>

<?php require_once __DIR__ . '/../inc/footer.php'; ?>
